tic;
% 定义参数
M = 3; % 根据需要设置 M 的值
N = 3; % 根据需要设置 N 的值
N0 = 20; % 设置 x 和 y 取值的数量
c0 = 0.001;
k=1;
c1=0;

% 定义 F(u) 和 a(u)
F = @(u) -20*u; %b/a的结果
a = @(u) 1/2; % 这里的示例为 a(u) = 1/2

% 在 [-M, N] 范围内生成 N0 个 x 和 y 点
x_values = linspace(-M+0.001, N-0.001, N0);
y_values = linspace(-M+0.001, N-0.001, N0);

% 初始化最小 result 和 result_4 变量
min_result = Inf;
min_result_4 = Inf;
best_x = NaN;
best_y = NaN;

% 遍历所有 x 和 y 的组合
for i = 1:N0
    for j = 1:N0
        x = x_values(i);
        y = y_values(j);
        
        if x < y
            % 计算 \frac{\exp(c(u))}{a(u)} 从 -M 到 x 的积分
            u_values = linspace(-M, x, 800); % 在积分范围内生成一系列 u 值
            c_values = arrayfun(@(u) compute_c(u, F), u_values); % 计算每个 u 对应的 c(u)
            exp_c_values = exp(c_values); % 计算 \exp(c(u))
            a_values = a(u_values); % 计算 a(u) 对应的值
            integrand_values = exp_c_values ./ a_values; % 计算 \frac{\exp(c(u))}{a(u)}
            result1 = trapz(u_values, integrand_values);
            result1_inv = 1 / result1; % 计算 \frac{1}{\text{result1}}

            % 计算 \frac{\exp(c(u))}{a(u)} 从 y 到 N 的积分
            u_values_2 = linspace(y, N, 800); % 在积分范围内生成一系列 u 值
            c_values_2 = arrayfun(@(u) compute_c(u, F), u_values_2); % 计算每个 u 对应的 c(u)
            exp_c_values_2 = exp(c_values_2); % 计算 \exp(c(u))
            a_values_2 = a(u_values_2); % 计算 a(u) 对应的值
            integrand_values_2 = exp_c_values_2 ./ a_values_2; % 计算 \frac{\exp(c(u))}{a(u)}
            result2 = trapz(u_values_2, integrand_values_2);
            result2_inv = 1 / result2;

            % 计算 \exp(-c(u)) 从 x 到 y 的积分
            u_values_3 = linspace(x, y, 800); % 在积分范围内生成一系列 u 值
            c_values_3 = arrayfun(@(u) compute_c(u, F), u_values_3); % 计算每个 u 对应的 c(u)
            exp_neg_c_values = exp(-c_values_3); % 计算 \exp(-c(u))
            result3 = trapz(u_values_3, exp_neg_c_values);
            result3_inv = 1 / result3;

            % 计算 result 和 result_4
            result = (result1_inv + result2_inv) * result3_inv;
            result_4 = result / 4;

            % 更新最小值
            if result < min_result
                min_result = result;
                min_result_4 = result_4;
                best_x = x;
                best_y = y;
            end
        end
    end
end

end_time = toc;
% 输出结果
disp(['x: ', num2str(best_x)]);
disp(['y: ', num2str(best_y)]);
disp(['最小的 result: ', num2str(min_result)]);
disp(['对应的 result_4: ', num2str(min_result_4)]);
disp(['所用时间：',num2str(end_time)])

% 定义 c(u) 为 y 在 0 到 u 上的积分
function cu = compute_c(u, y_func)
    cu = integral(@(t) y_func(t), 0, u);
end
